<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Provider extends Model
{
	protected $table = 'provider';
	protected $primaryKey = 'provider_id';

    protected $hidden = ['provider_email','provider_tel','provider_business_business_id'];

	public $timestamps = false;

    public function services()
    {
        return $this->belongsToMany('App\Service','service_provider','service_provider_provider_provider_id','service_provider_service_service_id');
    }

    public function timing() {
    	return $this->hasMany('App\Ptiming','provider_timing_provider_provider_id');
    }
}
