<?php

namespace App\Http\Controllers;

use App\Service;
use App\Stype;

use Illuminate\Http\Request;

class ServiceController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    //
    public function getAll(Request $req)
    {
        $bId = $req->input('bid');
        if(!$bId) {
            return abort(404);
        }
        $services = Stype::where('service_type_business_business_id',$bId)->with('services')->get();
        return $services->toJson(JSON_UNESCAPED_UNICODE);
    }

    public function getServicesByProvider($provider_id,Request $req) 
    {
        $bId = $req->input('bid');
        if(!$bId) {
            return abort(404);
        }
		$services = Stype::where('service_type_business_business_id', $bId)->whereHas('services.providers', function ($query) use ($provider_id,$bId){
    			$query->where('provider_id', $provider_id )->where('provider_business_business_id', $bId);
			})->with('services')->get();
		return $services->toJson(JSON_UNESCAPED_UNICODE);
    }

}
