<?php

namespace App\Http\Controllers;

use App\Provider;
use App\Appoitment;
use Carbon\Carbon;

use Illuminate\Http\Request;

class ProviderController extends Controller
{

    public function getAll(Request $req) {
        $bId = $req->input('bid');
        if(!$bId) {
            return abort(404);
        }
        $providers = Provider::where('provider_business_business_id',$bId)->get();
        if (!$providers->isEmpty()) 
        {
            return response()->json($providers,JSON_UNESCAPED_UNICODE);
        }
        return abort(404);
    }

    public function getProvidersByService($service_id, Request $req) {
        $bId = $req->input('bid');
        if(!$bId) {
            return abort(404);
        }
        $providers = Provider::where('provider_business_business_id',$bId)->whereHas('services', function ($query) use ($service_id,$bId){
                $query->where('service_id', $service_id )
                        ->where('service_business_business_id', $bId);
            })->get();
        if (!$providers->isEmpty()) 
        {
            return response()->json($providers,JSON_UNESCAPED_UNICODE);
        }
        return abort(404);
    }

    public function getProvider($provider_id, Request $req) {
        $bId = $req->input('bid');
        if(!$bId) {
            return abort(404);
        }
        $timingDateFrom = [];
        $timingDateTo   = [];
        $days = ['sun','mon','tue','wed','thu','fri','sat'];
        $timingDays = ['sun' => [],'mon' => [],'tue' => [],'wed' => [],'thu' => [],'fri' => [],'sat' => []];

        $providers = Provider::where('provider_business_business_id',$bId)->findOrFail($provider_id)->timing->toArray();

        array_map(function($c) use(&$timingDateFrom,&$timingDateTo) {
            array_push($timingDateFrom,strtotime($c['provider_timing_date_from']));
            array_push($timingDateTo,strtotime($c['provider_timing_date_to']));
        },$providers);
        $timingDateFrom = date('Y-m-d',max([min($timingDateFrom),time()]));
        $timingDateTo = date('Y-m-d',max($timingDateTo));

        foreach ($providers as $provider) {
            array_map(function($c) use(&$timingDays,$provider) {
                if ($provider['provider_timing_day'] == $c) {
                    $tFrom = strtotime($provider['provider_timing_date_from']);
                    $tFrom = max([$tFrom,time()]);
                    $tTo = strtotime($provider['provider_timing_date_to']);
                    if($tTo - $tFrom > 0)
                        array_push($timingDays[$c],$provider);
                }
            },$days);
        }

        return response()->json(
            [   
                'timing_date_from' => $timingDateFrom,
                'timing_date_to' => $timingDateTo,
                'timing' => $timingDays
            ]
            ,JSON_UNESCAPED_UNICODE);
    }


    public function getAvailableDate($provider_id, $date) {
        $time = strtotime($date);
        $timedispo = ['available_times'=>[]];
        //dd(date('Y-m-d', $time));
        //$provider = Ptiming::where('provider_timing_day',strtolower(date('D',$time)))
        $timings = Provider::whereHas('timing', function ($query) use ($time){
                $query->where('provider_timing_day', strtolower(date('D',$time)) );
            })->findOrFail($provider_id)->timing->where('provider_timing_day',strtolower(date('D',$time)));
        foreach ($timings as $timing) {
            //$timeFrom = max([strtotime($timing->provider_timing_date_from),time()]);
            $timeFrom = max([strtotime($timing->provider_timing_date_from),strtotime( date('Y-m-d', time()) )]);
            $timeTo   = strtotime($timing->provider_timing_date_to);
            if($timeTo - $timeFrom > 0 && $time >= $timeFrom && $time < $timeTo) {
                //dd(time() . ' ll ' . strtotime($timing->provider_timing_from));
                $timedispoFrom = date_parse(date('Y-m-d', $time).' '.$timing->provider_timing_from);
                $timedispoFrom = Carbon::create($timedispoFrom['year'],$timedispoFrom['month'],$timedispoFrom['day'],
                    $timedispoFrom['hour'],$timedispoFrom['minute'],$timedispoFrom['second']);

                $timedispoTo = date_parse(date('Y-m-d', $time).' '.$timing->provider_timing_to);
                $timedispoTo = Carbon::create($timedispoTo['year'],$timedispoTo['month'],$timedispoTo['day'],
                    $timedispoTo['hour'],$timedispoTo['minute'],$timedispoTo['second']);

                $appoitments = Appoitment::where('appoitment_provider_provider_id',$provider_id)
                ->whereBetween('appoitment_datetime_from', [$timedispoFrom,$timedispoTo])->get();

                $now = Carbon::now();
                if($timedispoFrom->isSameDay($now) && $timedispoFrom->lt($now)) {
                    // reset seconds to 0
                    $now->second = 0;
                    // minute will be 0 15 30 45 
                    if ($now->minute > 0 && $now->minute < 15) {
                        $now->minute = 15;
                    }elseif ($now->minute > 15 && $now->minute < 30) {
                        $now->minute = 30;
                    }elseif ($now->minute > 30 && $now->minute < 45) {
                        $now->minute = 45;
                    }elseif ($now->minute > 45) {
                        $now->minute = 0;
                        $now->hour++;
                    }
                    $timedispoFrom = $now;
                }
                while ($timedispoFrom->ne($timedispoTo) ) {
                    $available = true;
                    foreach($appoitments as $appoitment) {
                        $cfrom = Carbon::parse($appoitment->appoitment_datetime_from);
                        $cto = Carbon::parse($appoitment->appoitment_datetime_to);
                        if( $timedispoFrom->eq($cfrom) || $timedispoFrom->between($cfrom, $cto) ) {
                            $available = false;
                        }
                    }
                    $timedispo['available_times'][] = [
                        'time' => $timedispoFrom->format('h:i A'),
                        'available' => $available
                    ];
                    $timedispoFrom->addMinutes(15);
                }
                break;
            }
        }
        return response()->json($timedispo,JSON_UNESCAPED_UNICODE);
    }
}
