import React from 'react'
//import Slider from 'react-slick'
import Moment from 'moment'
import { extendMoment } from 'moment-range'
import { findDOMNode } from 'react-dom';

import OwlCarousel from 'react-owl-carousel2'

const moment = extendMoment(Moment)
//moment.locale('ar-sa')


export default class TimingDays extends React.Component {

constructor(props){
   super(props);

    this.state = {

    }
  }
  componentDidUpdate(prevProps, prevState) {
    //this.refs.days.goTo(0)
  }
  onChange(e,v) {
    this.setState({ checked: e.target.value });
    this.props.chooseTime(e,v)
  }
  render() {
      const options = {
        rtl: this.props.lang == 'ar' ? true : false,
        dots:false,
        nav:true,
        slideBy:4,
        navText : ["<i class='fa fa-angle-right'></i>","<i class='fa fa-angle-left'></i>"],
        responsive:{
        0 :{
          items: 5
        },
        600 :{
          items: 7
        },
    }
      };
        const days = this.props.days.map( (el,index) => {
          return(
              <div className="booking-days__day" key={index}>
                <label className="booking-days__day--radio"> 
                  <span>{el.date.format('ddd').toUpperCase()}</span>
                  <input type="radio" name={"date"+el.date.format('MYYYY')} disabled={!el.in_range} 
                  onChange={e => this.onChange(e,el.date.format('YYYY-MM-DD'))}
                  value={el.date.format('MDYYYY')}
                  checked={this.state.checked === el.date.format('MDYYYY')}
                  />
                  <div className={el.in_range ? "booking-days__day--rui in-range" : "booking-days__day--rui"}>{el.date.format('D')}</div>
                </label>
              </div>
            )
        });
    return (
<OwlCarousel ref="days" options={options}>
  {days}
</OwlCarousel>
        );
  }
}
