import React from 'react'
import {connect} from 'react-redux'
import reactStringReplace from 'react-string-replace'
import TimingDays from './TimingDays.jsx'
import {chooseTiming,resetTiming} from '../../actions';
import axios from 'axios'
import Moment from 'moment'
import { extendMoment } from 'moment-range'

const moment = extendMoment(Moment)
//moment.locale('ar-sa')


class Timing extends React.Component {

constructor(props){
   super(props);
    this.state = {
      data: [],
      months: [],
      month: 0,
      loading: true,
      days: [],
      available: [],
      choosedDay: false,
      choosedTiming: false,
    }
  }
  componentDidMount() {
    axios.get(this.props.salonSettings.call_url+'provider/'+ this.props.providerId +'/timing?bid='+this.props.salonSettings.business_id)
      .then( ({ data }) => {
        let months = Array.from(moment.range(data.timing_date_from, data.timing_date_to).by('month'));
        //months = months.map(m => m.format('MMMM YYYY'));
         this.setState({
          data: data,
          months: months,
          loading: false,

        });
         this._getDays();
      });
  }
  _reset(e) {
    e.preventDefault();
    this.props.resetTiming();
    this.setState({choosedTiming: false});
  }
  _getMonth() {
    if(this.state.months.length){
       let month = null
      if(this.props.salonSettings.l.lang == 'ar') {
        month = this.state.months[this.state.month].locale('ar-sa').format('MMMM YYYY');
      }else {
        month = this.state.months[this.state.month].locale(this.props.salonSettings.l.lang).format('MMMM YYYY');
      }
      moment.locale('en');
      return month;
    }  
  }
  _getDays() {
    let month = this.state.months[this.state.month].locale('en')
    let numberOfDaysInMonth = this.state.months[this.state.month].daysInMonth()
    // mapping days of selected month
    let daysOfmonth = [...Array(numberOfDaysInMonth).keys()].map(m => {
        let date = moment().set({'year': month.year(), 'month': month.month(), 'date': m+1});
        let in_range = false
        let day      = date.format('ddd').toLowerCase()
          for (let tday of this.state.data.timing[day]) {
            let mday = tday['provider_timing_date_from']
            if(moment(moment()).isAfter(mday)) {
              mday = moment()
            }
            if(moment.range(mday,tday['provider_timing_date_to']).contains(date)){
              in_range = true
              break
            }
          }
          return {'date': date, 'in_range': in_range }
      });
    this.setState({
      days: daysOfmonth,
    })
  }
  _getNextMonth(e){
    if(this.state.month < this.state.months.length - 1){
      this.setState({month: ++this.state.month})
      this._getDays();
    }
  }
  _getPreviousMonth(e){
    if(this.state.month > 0){
      this.setState({month: --this.state.month})
      this._getDays();
    }
  }
  _getNextMonthClassName(){
    if (this.state.month >= this.state.months.length - 1){
      return 'booking-timing__months--nbtn is-hide'
    }
    return 'booking-timing__months--nbtn'
  }
  _getPreviousMonthClassName(){
    if (this.state.month <= 0){
      return 'booking-timing__months--pbtn is-hide'
    }
    return 'booking-timing__months--pbtn'
  }
  _rGetMonths() {
      if(this.state.months.length > 0 && !this.state.choosedTiming) {
        return (<div className="booking-timing__months" unselectable="on">
          <div className={this._getNextMonthClassName()} onClick={(e) => this._getNextMonth(e)}>
            <i className="fa fa-angle-right" aria-hidden="true"></i>
          </div>
          <div className="booking-timing__months--content ">{this._getMonth()}</div>
          <div className={this._getPreviousMonthClassName()} onClick={(e) => this._getPreviousMonth(e)}>
            <i className="fa fa-angle-left" aria-hidden="true"></i>
          </div>
        </div>)
      }
  }
  _rGetDays() {
    let days = this.state.days
    if(days.length > 0 && !this.state.choosedTiming) {
      return (
        <div className="booking-timing__days">
          <TimingDays lang={this.props.salonSettings.l.lang} days={days} chooseTime={(e,d) => this._chooseTime(e,d)}/>
        </div>
        )
    }
  }
  _chooseTime(e,d) {
    e.stopPropagation()
    this.setState({ loading: true,choosedDay: d });
    axios.get(window._nbSettings.call_url+'provider/'+ this.props.providerId +'/timing/'+ d +'/available?bid='+this.props.salonSettings.business_id)
      .then( ({ data }) => {
        this.setState({
          available: data.available_times,
          loading: false
        })
    });
  }
  _rGetavailableTimes() {
    if(this.state.available.length > 0 && !this.state.choosedTiming) {
      const availableTimes = this.state.available.map((el,index) => {
        return (
            <div key={index} className="booking-date__content">
              <a className={!el.available ? 'not-available' : ''} onClick={(e,k) => el.available && this.chooseTiming(e,el.time)}><i className="fa fa-clock-o" aria-hidden="true"></i>{el.time}</a>
            </div>
          )
      })
      return <div className="booking-timing__date">{availableTimes}</div>
    }
  }
  chooseTiming(e,k) {
    e.preventDefault();
    const choosedTiming = moment(this.state.choosedDay + k, 'YYYY-MM-DDhh:mm A')
    this.props.chooseTiming({
      'year': choosedTiming.year(),
      'month': choosedTiming.month(),
      'day': parseInt(choosedTiming.format('D')),
      'hour': parseInt(choosedTiming.format('H')),
      'minute': parseInt(choosedTiming.format('m')),
    })
    this.setState({
      choosedTiming: choosedTiming,
    })
  }
  _rGetTiming() {
    if(this.state.choosedTiming) {
      let timing = this.state.choosedTiming
      let time = timing.format('hh:mm A')
      let year = timing.year()
      let day = timing.format('D')
      if(this.props.salonSettings.l.lang == 'ar'){
        timing.locale('ar-sa')
      }else {
        timing.locale(this.props.salonSettings.l.lang)
      }
      let dayName = timing.format('dddd')
      let month = timing.format('MMMM')
      let timingPhrase = this.props.salonSettings.l.timing_phrase
      timingPhrase = reactStringReplace(timingPhrase, ":day_name", (match, i) => (dayName))
      timingPhrase = reactStringReplace(timingPhrase, ":month_day_year", (match, i) => (<span key={'MY'+i}><i>{day}</i> {month} <i>{year}</i></span>))
      timingPhrase = reactStringReplace(timingPhrase, ":time", (match, i) => (<span key={'T'+i}><i>{time}</i></span>))
      return (
        <div className="booking-timing__timing">{timingPhrase}</div>)
    }
  }
  _choosed () {
    if (!this.state.choosedTiming) {
      return false;
    }
    return true;
  }
  _choosedClassName () {
    if(this._choosed()) {
      return "booking-providers choosed"
    }
    return "booking-providers"
  }
  render() {
    return (
      <div className={this._choosedClassName()}>
        <div className="booking-title">
        	<h4>{this.props.salonSettings.l.available_timing_title}</h4>
        	<a className="booking-refresh--btn" onClick={(e) => this._reset(e) }><i className="fa fa-refresh" aria-hidden="true"></i></a>
          {this.state.loading && <div className="booking-loader"><div className="booking-loader__inner" /></div>}
        </div>

        {this._rGetMonths()}
        {this._rGetDays()}
        {this._rGetavailableTimes()}
        {this._rGetTiming()}
        
      </div>);
  }
}
const mapStateToProps = ({salon,provider}) => {
  return {
    salonSettings: salon,
    providerId: provider.id,
  }
};
const mapDispatchToProps = (dispatch) => {
 return {
    chooseTiming: (data) => dispatch(chooseTiming(data)),
    resetTiming: () => dispatch(resetTiming()),
 }
}
export default connect(mapStateToProps,mapDispatchToProps)(Timing)