import React from 'react'
import {connect} from 'react-redux'
import Moment from 'moment'
import { extendMoment } from 'moment-range'

const moment = extendMoment(Moment)
moment.locale('en')


class SubmitForm extends React.Component {

constructor(props){
   super(props);
    this.state = {

    }
  }
  componentDidMount() {

  }
  getTime() {
    let timing = this.props.timing
    let date = moment().minute(timing.minute)
    date.hour(timing.hour)
    date.date(timing.day)
    date.month(timing.month)
    date.year(timing.year)
    return date.format('YYYY-MM-DD HH:mm:00')
  }

  render() {
    return (
      <form method="POST">
        <input type="hidden" name="provider" value={this.props.providerId} />
        <input type="hidden" name="service" value={this.props.serviceId} />
        <input type="hidden" name="time" value={this.getTime()} />
        <input type="hidden" name="_token" value={this.props.salonSettings.csrf_token} />
        <button className="booking-submit"><i className="fa fa-check" aria-hidden="true"></i> {this.props.salonSettings.l.confirm_appointment}</button>
      </form>);
  }
}
const mapStateToProps = ({salon,provider,service,timing}) => {
  return {
    salonSettings: salon,
    providerId: provider.id,
    serviceId: service.data.service_id,
    timing: timing.data,
  }
}
export default connect(mapStateToProps,null)(SubmitForm)