import React from 'react'
import {connect} from 'react-redux'
import Service from './Service.jsx'
import {chooseService,resetService,resetProvider,resetTiming} from '../../actions';
import axios from 'axios'


class Services extends React.Component {
constructor(props){
   super(props);
    this.state = {
      data: [],
      loading: true,
      choosedServiceId: false,
      choosedServiceTypeId: false,
    }
  }
  componentDidMount() {
    if(this.props.salonSettings.s_with == 'services') {
      if(this.props.salonSettings.i_data.length) {
            this.setState({
            data:this.props.salonSettings.i_data,
            loading: false
          })
          return true
      }
    axios.get(this.props.salonSettings.call_url+'services?bid='+this.props.salonSettings.business_id)
      .then( ({ data }) => {
        this.setState({
          data: data,
          loading: false
        });
      });
    }else {
    axios.get(this.props.salonSettings.call_url+'services/provider/'+this.props.providerId+'?bid='+this.props.salonSettings.business_id)
      .then( ({ data }) => {
        this.setState({
          data: data,
          loading: false
        });
      });
    }
  }
  _reset(e) {
    e.preventDefault();
    if(this.props.salonSettings.s_with == 'services') {
      this.props.resetProvider();
    }
    this.props.resetService();
    this.props.resetTiming();
    this.setState({choosedServiceId: false,choosedServiceTypeId: false});
  }
  _choosedService(id,tId,el) {
    this.setState({choosedServiceId: id,choosedServiceTypeId: tId});
    this.props.chooseService(el);
  }
  _choosed () {
    if (this.state.choosedServiceId) {
      return true;
    }
    return false;
  }
  _choosedClassName () {
    if(this._choosed()) {
      return "booking-services choosed"
    }
    return "booking-services"
  }
  render() {
    const servicesElements = this.state.data.map((el) => {
      if(!this.state.choosedServiceId) {
        if(el.services.length > 0) {
          return (<Service key={el.service_type_id} id={el.service_type_id} 
          title={el['service_type_title_'+this.props.salonSettings.l.lang]} 
          subServices={el.services}
          serviceTypeImg={el.service_type_img}
          scount={el.services.length}
          lang={this.props.salonSettings.l.lang}
          currencyCode={this.props.salonSettings.l.currency_code}
          servicesCount={this.props.salonSettings.l.services_count}
          assetsUrl={this.props.salonSettings.assets_url}
          choosed={this.state.choosedServiceId} 
          choosedService={(k,i,el) => this._choosedService(k,i,el) }/>)
        }  
      }
      if(this.state.choosedServiceTypeId == el.service_type_id) {
          return (<Service key={el.service_type_id} id={el.service_type_id} 
          subServices={el.services} 
          lang={this.props.salonSettings.l.lang}
          currencyCode={this.props.salonSettings.l.currency_code}
          choosed={this.state.choosedServiceId} />)
      }
    })
    return (
      <div className={this._choosedClassName()}>
        <div className="booking-title">
        	<h4>{this.props.salonSettings.l.services_title}</h4>
        	<a className="booking-refresh--btn" onClick={(e) => this._reset(e) }><i className="fa fa-refresh" aria-hidden="true"></i></a>
          {this.state.loading && <div className="booking-loader"><div className="booking-loader__inner" /></div>}
        </div>
        {servicesElements}
      </div>);
  }
}
const mapStateToProps = ({salon, provider}) => {
  return {
    salonSettings: salon,
    providerId: provider.id,
  };
};
const mapDispatchToProps = (dispatch) => {
 return {
    chooseService: (data) => dispatch(chooseService(data)),
    resetService: () => dispatch(resetService()),
    resetProvider: () => dispatch(resetProvider()),
    resetTiming: () => dispatch(resetTiming()),
 }
}
export default connect(mapStateToProps,mapDispatchToProps)(Services)