import React from 'react'
import reactStringReplace from 'react-string-replace'
import $ from 'jquery'
//port {connect} from 'react-redux'

export default class Service extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
    	serviceId: false
    }
  }
  _chooseService (e,id,el) {
  	e.preventDefault();
  	this.setState({serviceId: id});
  	this.props.choosedService(id,this.props.id,el);
  }
  handleClick (e) {
		let $elmToggle = $(e.target).parents('.booking-services__service--outer').find('.booking-service__subsevice');
		let $elmToggleA = $(e.target).parents('.booking-services__service--outer').siblings().find('.booking-service__subsevice');

		$elmToggleA.slideUp({duration: 300});
		$elmToggleA.parents('.booking-services__service--outer').removeClass('is-open');		

		if($elmToggle.is(':visible')) {
			$elmToggle.slideUp({duration:300});
			$elmToggle.parents('.booking-services__service--outer').removeClass('is-open');
		}else {
			$elmToggle.slideDown({duration:300});
			$elmToggle.parents('.booking-services__service--outer').addClass('is-open');
		}
  }
  render() {

    if(!this.props.choosed){
	const subServicesElements = this.props.subServices.map((el) => {
		el.service_price = Number(parseFloat(el.service_price).toFixed(2)).toLocaleString('en', {minimumFractionDigits: 2});
          return (<div className="booking-subservice__service" key={el.service_id}>
	        		<label className="booking-subservice__service--radio">
	        			<input type="radio" name="service" onChange={(e) => this._chooseService(e,el.service_id,el)}/>
	        			<div className="booking-subservice__service--rui"></div>
	        			{reactStringReplace(el['service_title_'+this.props.lang], /(\d+)/g, (match, i) => (
         									 <span className="booking-subservice__service--number" key={i}>{match}</span>
        				))}
	        			<div className="booking-subservice__service--prince"><span>{el.service_price}</span>{this.props.currencyCode}</div>
	        		</label>
	        	</div>)
    })

    return (
      	<div className="booking-services__service--outer">
	      	<div className="booking-services__service" onClick={this.handleClick.bind(this)}>
	      		<div className="booking-service__accicon">
	      			<i className="fa fa-chevron-left" aria-hidden="true"></i>
	      		</div>
	      		<div className="booking-service__thumb">
	      			<img src={ this.props.assetsUrl + 'img/services/' + this.props.serviceTypeImg } alt="{this.props.title}" />
	      		</div>
				<div className="booking-service__content">
	        		<h5>{this.props.title}</h5>
	        		<h6><i className={this.props.lang == 'ar' ? 'fa fa-angle-left' : 'fa fa-angle-right'} aria-hidden="true"></i>
	        		 {
	        		 	reactStringReplace(this.props.servicesCount, ":number",(match, i) => (
	        		 				<strong key={i}>{this.props.scount}</strong>
	        		 ))}
	        		 </h6>
	        	</div>
	      	</div>
        	<div className="booking-service__subsevice">{subServicesElements}</div>
      	</div>
      )}else {
      		const serviceElement = this.props.subServices.map((el) => {
      			if(this.state.serviceId == el.service_id){
					el.service_price = Number(parseFloat(el.service_price).toFixed(2)).toLocaleString('en', {minimumFractionDigits: 2});
		          	return (<div className="booking-services__service" key={el.service_id}>
		          		<div className="booking-service__choosed">
		          			<i className={this.props.lang == 'ar' ? 'fa fa-angle-left' : 'fa fa-angle-right'} aria-hidden="true"></i> {el['service_title_'+this.props.lang]}
		          			<div className="booking-service__choosed--price"><span>{el.service_price}</span>{this.props.currencyCode}</div>
		          		</div>
		          	</div>)
      			}
    		})
			return (
					<div className="booking-services__service--outer">{serviceElement}</div>
			)
    	}
  }
}