import React from 'react';
import {connect} from 'react-redux';
import Provider from './Provider.jsx'
import {loadProviders,chooseProvider,resetProvider,resetService,resetTiming} from '../../actions'
import axios from 'axios'
import {resolve as URL} from 'url'


class Providers extends React.Component {
constructor(props){
   super(props);
    this.state = {
      loading: true,
      choosedProviderId: false,
      data: []
    }
  }
  componentDidMount() {
    if(this.props.salonSettings.s_with == 'services') {
      axios.get( URL(this.props.salonSettings.call_url, './providers/service/'+this.props.serviceId+'?bid='+this.props.salonSettings.business_id) )
        .then( ({ data }) => {
           this.setState({
            data: data,
            loading: false
          });
        });
    }else {
      if(this.props.salonSettings.i_data.length) {
            this.setState({
            data:this.props.salonSettings.i_data,
            loading: false
          })
          return true
      }
      axios.get( URL(this.props.salonSettings.call_url, './providers?bid='+this.props.salonSettings.business_id) )
        .then( ({ data }) => {
           this.setState({
            data: data,
            loading: false
          });
        });
    }
  }
  _reset(e) {
    e.preventDefault();
    if(this.props.salonSettings.s_with == 'providers') {
      this.props.resetService();
    }
    this.props.resetProvider();
    this.props.resetTiming();
    this.setState({choosedProviderId: false});
  }
  _choosed () {
    if (!this.state.choosedProviderId) {
      return false;
    }
    return true;
  }
  _choosedClassName () {
    if(this._choosed()) {
      return "booking-providers choosed"
    }
    return "booking-providers"
  }
  _chooseProvider (id) {
    this.props.chooseProvider(id);
    this.setState({choosedProviderId: id});
  }
  render() {
    const providersElements = this.state.data.map((el) => {
            if (!this.state.choosedProviderId) {
              return (
                  <Provider key={el.provider_id} id={el.provider_id} data={el} assetsUrl={this.props.salonSettings.assets_url} lang={this.props.salonSettings.l.lang} chooseProvider={(k) => this._chooseProvider(k)}
                  choosed={this.state.choosedProviderId} />
                )
            }
            if (el.provider_id == this.state.choosedProviderId){
              return <Provider key={el.provider_id} id={el.provider_id} data={el} assetsUrl={this.props.salonSettings.assets_url} lang={this.props.salonSettings.l.lang}
              choosed={this.state.choosedProviderId} />
            }
           
    })
    return (
      <div className={this._choosedClassName()}>
        <div className="booking-title">
        	<h4>{this.props.salonSettings.l.providers_title}</h4>
        	<a className="booking-refresh--btn" onClick={(e) => this._reset(e) }><i className="fa fa-refresh" aria-hidden="true"></i></a>
          {this.state.loading && <div className="booking-loader"><div className="booking-loader__inner" /></div>}
        </div>
        {providersElements}
      </div>);
  }
}
const mapStateToProps = ({salon,service}) => {
  console.log(service);
  return {
      salonSettings: salon,
      serviceId: service.data.service_id,
  }
};
const mapDispatchToProps = (dispatch) => {
 return {
    chooseProvider: (id) => dispatch(chooseProvider(id)),
    resetProvider: () => dispatch(resetProvider()),
    resetService: () => dispatch(resetService()),
    resetTiming: () => dispatch(resetTiming()),
 }
}
export default connect(mapStateToProps, mapDispatchToProps)(Providers)