import React from 'react';
import {connect} from 'react-redux';
import Providers from './booking/Providers.jsx';
import Services from './booking/Services.jsx';
import Timing from './booking/Timing.jsx';
import SubmitForm from './booking/SubmitForm.jsx';

class Booking extends React.Component {
  render() {
    if(this.props.salonSettings.s_with == 'providers') {
      return (
        <div className="booking">
          <Providers />
          {this.props.providerId && <Services />}
          {this.props.choosedService && <Timing />}
          {this.props.choosedTiming && <SubmitForm />}
        </div>);
    }else {
      return (
        <div className="booking">
          <Services />
          {this.props.choosedService && <Providers />}
          {this.props.providerId && <Timing />}
          {this.props.choosedTiming && <SubmitForm />}
        </div>);
    }

  }
}
const mapStateToProps = (state) => {
  return {
      salonSettings: state.salon,
  		providerId : state.provider.id,
      choosedService : state.service.choosedService,
  		choosedTiming : state.timing.choosedTiming,
  }
};
export default connect(mapStateToProps)(Booking)