<?php

namespace App\Http\Controllers;

use App\Service;
use App\Stype;

class ServiceController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    //
    public function getAll()
    {
        $services = Stype::with('services')->get();
        return $services->toJson(JSON_UNESCAPED_UNICODE);
    }

    public function getServicesByProvider($provider_id) 
    {
		$services = Stype::whereHas('services.providers', function ($query) use ($provider_id){
    			$query->where('provider_id', $provider_id );
			})->with('services')->get();
		return $services->toJson(JSON_UNESCAPED_UNICODE);
    }

}
