<?php

/**
* getLookupMainTableSettings - tests whether the lookup link exists between the tables
*
*  returns array with ProjectSettings class for main table if the link exists in project settings.
*  returns NULL otherwise
*/
function getLookupMainTableSettings($lookupTable, $mainTableShortName, $mainField, $desiredPage = "")
{
	global $lookupTableLinks;
	if(!isset($lookupTableLinks[$lookupTable]))
		return null;
	if(!isset($lookupTableLinks[$lookupTable][$mainTableShortName.".".$mainField]))
		return null;
	$arr = &$lookupTableLinks[$lookupTable][$mainTableShortName.".".$mainField];
	$effectivePage = $desiredPage;
	if(!isset($arr[$effectivePage]))
	{
		$effectivePage = PAGE_EDIT;
		if(!isset($arr[$effectivePage]))
		{
			if($desiredPage == "" && 0 < count($arr))
			{
				$effectivePage = $arr[0];
			}
			else
				return null;
		}
	}
	return new ProjectSettings($arr[$effectivePage]["table"], $effectivePage);
}

/** 
* $lookupTableLinks array stores all lookup links between tables in the project
*/
function InitLookupLinks()
{
	global $lookupTableLinks;

	$lookupTableLinks = array();

	$lookupTableLinks["business2"]["appoitment.appoitment_business_business_id"]["edit"] = array("table" => "appoitment", "field" => "appoitment_business_business_id", "page" => "edit");
	$lookupTableLinks["service"]["appoitment.appoitment_service_service_id"]["edit"] = array("table" => "appoitment", "field" => "appoitment_service_service_id", "page" => "edit");
	$lookupTableLinks["service_type"]["appoitment.appoitment_service_type_id"]["edit"] = array("table" => "appoitment", "field" => "appoitment_service_type_id", "page" => "edit");
	$lookupTableLinks["provider_services_details"]["appoitment.appoitment_provider_provider_id"]["edit"] = array("table" => "appoitment", "field" => "appoitment_provider_provider_id", "page" => "edit");
	$lookupTableLinks["status"]["appoitment.appoitment_satuts"]["edit"] = array("table" => "appoitment", "field" => "appoitment_satuts", "page" => "edit");
	$lookupTableLinks["service_type"]["service.service_service_type_id"]["edit"] = array("table" => "service", "field" => "service_service_type_id", "page" => "edit");
	$lookupTableLinks["service_provider"]["service.service_service_provider_id"]["edit"] = array("table" => "service", "field" => "service_service_provider_id", "page" => "edit");
	$lookupTableLinks["provider"]["service_provider.service_provider_provider_provider_id"]["edit"] = array("table" => "service_provider", "field" => "service_provider_provider_provider_id", "page" => "edit");
	$lookupTableLinks["service"]["service_provider.service_provider_service_service_id"]["edit"] = array("table" => "service_provider", "field" => "service_provider_service_service_id", "page" => "edit");
	$lookupTableLinks["provider"]["provider_timing.provider_timing_provider_provider_id"]["edit"] = array("table" => "provider_timing", "field" => "provider_timing_provider_provider_id", "page" => "edit");
}

?>